/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.html;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;

public class HtmlColorParser {
    @Nullable
    public static Color parseHtmlColor(String cs) {
        if (Strings.isNullOrEmpty(cs)) {
            return null;
        }
        if (cs.startsWith("#")) {
            return Color.decode(cs);
        }
        if (cs.startsWith("rgba(")) {
            List<String> rgba = Splitter.on(',').splitToList(cs.substring(5, cs.length() - 1));
            try {
                int r = Integer.parseInt(rgba.get(0).trim());
                int g2 = Integer.parseInt(rgba.get(1).trim());
                int b = Integer.parseInt(rgba.get(2).trim());
                float a = Float.parseFloat(rgba.get(3).trim());
                return new Color((float)r / 255.0f, (float)g2 / 255.0f, (float)b / 255.0f, a);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (cs.startsWith("rgb(")) {
            List<String> rgba = Splitter.on(',').splitToList(cs.substring(4, cs.length() - 1));
            try {
                int r = Integer.parseInt(rgba.get(0).trim());
                int g3 = Integer.parseInt(rgba.get(1).trim());
                int b = Integer.parseInt(rgba.get(2).trim());
                return new Color((float)r / 255.0f, (float)g3 / 255.0f, (float)b / 255.0f);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

